<?php
/* @var $interiorId int */
/* @var $maxTasks int */
/* @var $tasks int */

echo CHtml::scriptFile(Yii::app()->baseUrl . '/js/lib/jquery.autoSuggest.minified.js');
echo CHtml::cssFile(Yii::app()->baseUrl . '/css/autoSuggest.css')
?>

<div class="biuroZleceniaXrDialogCls" id="biuroZleceniaXrTender">
	<table>
		<tr>
			<td><strong>Dziedzina</strong></td><td id="biuroZleceniaXrTDziedzina"></td>
		</tr><tr>
			<td><strong>Poziom</strong></td><td id="biuroZleceniaXrTPoziom"></td>
		</tr><tr>
			<td><strong><?php echo CHtml::label('Cena', 'tender_value') ?></strong></td>
			<td>
				<div><?php echo CHtml::textField('tender_value'); ?></div>
				<div class="errorMsg"><!-- errors goes here --></div>
			</td>
		<tr><td colspan="2" style="font-size: 10px;">Wyższa cena to większy zysk, jednak konkurencyjne firmy mogą wygrać przetarg oferując niższą cenę.</td></tr>
		</tr><tr>
			<td><strong><?php echo CHtml::label('Uzasadnienie', 'tender_note') ?></strong>
				<br/><span style="font-size: 10px;">Dlaczego to właśnie wasza firma powinna zostać wybrana?</span>
			</td>
			<td>
				<div><?php echo CHtml::textArea('tender_note','',array('style'=>'height:100px')); ?></div>
				<div class="errorMsg"><!-- errors goes here --></div>
			</td>
		</tr><tr>
			<td><strong><?php echo CHtml::label('Zaproś inną firmę', 'tender_invite') ?></strong>
				<br/><span style="font-size: 10px;">(Musi posiadać certyfikat)</span>
			</td>
			<td>
				<div id="invitePlaceholder"><?php echo CHtml::textField('tender_invite'); ?></div>
				<div class="errorMsg"><!-- errors goes here --></div>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="font-size: 10px; padding-top: 10px;">
			Zapraszając inną firmę do współpracy będziecie mogli wspólnie rozwiązywać przetargowe zlecenia. Po poprawnym rozwiązaniu wszystkich przetargowych zleceń (ilość zależna od zgodności przetargu z dziedziną firmy, ilości osób w firmie i ilości firm startujących razem do przetargu) zapłata zostanie podzielona pomiędzy obie firmy.
			</td>
		</tr>
	</table>
</div>

<script type="text/javascript">
(function()
{
	var KONTRAHENT_ID = <?php echo json_encode((int)$kontrahent->id); ?>;

	if (!KONTRAHENT_ID)
	{
		var hash = window.location.hash;
		hash = hash.substring(1, hash.length-1);
		window.location.hash = hash;
		return;
	}

	function dispatchEventHandlers()
	{
		$(document).off('taskList.przedsiebiorcaDialogueEvents');
		$(document).off('ordersList.przedsiebiorcaDialogueEvents');
		$(document).off('taskListEn.przedsiebiorcaDialogueEvents');
		$(document).off('ordersListEn.przedsiebiorcaDialogueEvents');
		$(document).off('orderReputationOk.przedsiebiorcaDialogueEvents');
		$(document).off('orderReputationBad.przedsiebiorcaDialogueEvents');
		$(document).off('taskReputationOk.przedsiebiorcaDialogueEvents');
		$(document).off('taskReputationBad.przedsiebiorcaDialogueEvents');
	}
	dispatchEventHandlers();

  $(window).on('hashchange.przedsiebiorcaDialogueEvents', function(){
		$(document).off('reputationOk.przedsiebiorcaDialogueEvents');
		$(document).off('reputationBad.przedsiebiorcaDialogueEvents');
		$('#biuroZleceniaXrDialog').parent().remove();
		dispatchEventHandlers();
		$(window).off('hashchange.przedsiebiorcaDialogueEvents');
  });

	$(document).on('orderReputationOk.przedsiebiorcaDialogueEvents', function() {
		return ( <?php echo json_encode($lessonActive && $tenders && $canCooperate) ?> && window.userdata.ilosc_biur>0 );
	});
	$(document).on('orderReputationBad.przedsiebiorcaDialogueEvents', function() {
		return <?php echo json_encode($lessonActive && $tenders && !$canCooperate) ?>;
	});
	$(document).on('taskReputationOk.przedsiebiorcaDialogueEvents', function() {
		return ( <?php echo json_encode($lessonActive && $canCooperate) ?> && window.userdata.ilosc_biur>0 );
	});
	$(document).on('taskReputationBad.przedsiebiorcaDialogueEvents', function() {
		return <?php echo json_encode($lessonActive && !$canCooperate) ?>;
	});

	var MAX_TASKS = <?php echo json_encode($maxTasks); ?>;
	var TASKS = <?php echo json_encode($tasks); ?>;

	function enableBts(enable)
	{
		var objs = $('.ui-dialog-titlebar-close, .action, .tasksBoxBodyRefresh');
		if (enable)
			objs.removeClass('disabled');
		else
			objs.addClass('disabled');
	}

	function applayToTender(task, doneCb)
	{
		enableBts(false);
		$.ajax({
			type: 'GET', url: window.links.studentAjaxGetCompaniesToTender,
			data: { tenderId: task.id },
			success: function(companies){
				//console.log(companies);
				$('#biuroZleceniaXrTender').dialog({
					title: 'Aplikuj do przetargu',
					modal: true, autoOpen: true,
					closeOnEscape: false,
					hide: { effect: 'clip', duration: 500 },
					show: { effect: 'scale', duration: 600 },
					position: { my: "center", at: "center", of: window },
					close: function(){ $(this).parent().remove(); },
					open: function(){
						var _dlg = $(this);
						_dlg.find('#tender_value, #tender_invite').parents('tr').removeClass('error');
						_dlg.find('#biuroZleceniaXrTDziedzina').text(task.dziedzina);
						_dlg.find('#biuroZleceniaXrTPoziom').text(task.level);
						_dlg.find('#invitePlaceholder').html('<input type="text" name="tender_invite" id="tender_invite" value="" />');
						_dlg.find('#tender_invite').autoSuggest(companies.companies, {
							selectedItemProp: 'nazwa',
							searchObjProps: 'nazwa',
							selectedValuesProp: 'id',
							asHtmlID: 'biuroZleceniaXrTFirmy',
							startText: 'Wpisz nazwę firmy',
							limitText: 'Nie można dodawać więcej firm',
							emptyText: 'Brak wyników',
							selectionLimit: <?php echo json_encode((int)ParametryGry::getValue('PRZETARG_MAX_ROZMIAR_GRUPY', 3)-1); ?>
						});
						if (companies.companies.length == 0) {
							_dlg.find('#tender_invite').addClass('disabled');
							_dlg.find('#tender_invite').prop('disabled', 1);
							_dlg.find('#tender_invite').val('Brak firm do współpracy');
						}
					},
					buttons: [{
						text: 'Wyślij',
						click: function()
						{
							var _dlg = $(this);
							//0. remove prevoious errors
							_dlg.find('#tender_value, #tender_invite, #tender_note').parents('tr').removeClass('error');
							function markError(obj, msg) {
								obj.parents('tr').addClass('error');
								obj.parents('tr').find('.errorMsg').text(msg);
								obj.focus();
							}
							//1. gather parameters (cena)
							var field1 = _dlg.find('#tender_value');
							var cena = parseFloat(field1.val());
							if (isNaN(cena)) {
								markError(field1, 'Niewłasciwa cena (nie float)');
								return;
							}
							else if (cena <= 0) {
								markError(field1, 'Cena nie może być mniejsza lub równa zero.');
								return;
							}
							var note = _dlg.find('#tender_note').val();
							//1. gather parameters (firmy)
							if($("#invitePlaceholder").find(".as-selection-item").size() > <?php echo (int)ParametryGry::getValue('PRZETARG_MAX_ROZMIAR_GRUPY', 3)-1?>) {
								markError($("#invitePlaceholder"), 'Maksymalna dopuszczalna ilość zaproszonych firm to <?php echo (int)ParametryGry::getValue('PRZETARG_MAX_ROZMIAR_GRUPY', 3)-1?>');
								return;
							}
							var field2 = _dlg.find('#as-values-biuroZleceniaXrTFirmy');
							var field2v = field2.val();
							var inv = field2v == null ? [] : field2.val().split(',');
							if (inv.length && inv[inv.length-1].length == 0)
								inv.pop();
							//2. send request to server
							enableBts(false);
							$.ajax({
								type: 'POST',
								url: window.links.studentAjaxTakeOrder,
								data: {
									tenderId: task.id,
									value: cena,
									note: note,
									invitations: inv
								},
								success: function(data){
									//console.log(data);
									if (data.error)
										showMessage('Błąd', data.error);
									else {
										//shwo results
										var html = 'Twoje zgłoszenie zostało wysłane.';
										function companyName(id) {
											for (var i in companies.companies)
												if (companies.companies[i].id == id)
													return companies.companies[i].nazwa;
											return null;
										}
										if (data.invitations.length) {
											html += '<br/><br/>Wysłano zaproszenia do:<br/>';
											for (var i in data.invitations) {
												var inv = data.invitations[i];
												html += companyName(inv.id) + ': ' + (inv.error ? inv.error : 'OK') + '.<br/>';
											}
										}
										showMessage('Wysłano aplikację', html);
										doneCb();
										_dlg.dialog('close');
									}
								},
								complete: function() {
									enableBts(true);
								}
							});
						}
					},{
						text: 'Anuluj',
						click: function() {
							$(this).dialog('close');
						}
					}],
					draggable: true, resizable: false,
					width: 430, height: 490
				});
			},
			complete: function(){ enableBts(true); }
		});
	}

	$(document).on('taskList.przedsiebiorcaDialogueEvents', function(){
		tasksDialogOpen({
			endpointParams: { kontrahentId: KONTRAHENT_ID },
			endpoint: window.links.studentAjaxFetchTasks,
			maxTasks: MAX_TASKS, tasks: TASKS, vat: <?php echo $vat; ?>,
			actions: ['Select'],
			title: '<?php echo '<img style="vertical-align:middle;margin-right:5px;" title="' . $kontrahent->dziedzina->nazwa . '" alt="' .
				$kontrahent->dziedzina->nazwa . '" src="' . $kontrahent->dziedzina->getNamesAsImageUrl(true) .
				'"/>' . $kontrahent->nazwa; ?> - ' + 'Lista zleceń',
			enable: enableBts
		});
	});
	$(document).on('taskListEn.przedsiebiorcaDialogueEvents', function(){
		tasksDialogOpen({
			endpointParams: { kontrahentId: KONTRAHENT_ID, lang: 1 },
			endpoint: window.links.studentAjaxFetchTasks,
			maxTasks: MAX_TASKS, tasks: TASKS, vat: <?php echo $vat; ?>,
			actions: ['Select'],
			title: '<?php echo '<img style="vertical-align:middle;margin-right:5px;" title="' . $kontrahent->dziedzina->nazwa . '" alt="' .
				$kontrahent->dziedzina->nazwa . '" src="' . $kontrahent->dziedzina->getNamesAsImageUrl(true) .
				'"/>' . $kontrahent->nazwa; ?> - ' + 'List of available orders',
			enable: enableBts
		});
	});

	$(document).on('ordersList.przedsiebiorcaDialogueEvents', function(){
		$('#bzOrdersTable').show();
		$('#bzOrdersWait').hide();
		$('#bzOrdersDialog').dialog({
			title: 'Przetargi',
			modal: true, autoOpen: true,
			closeOnEscape: false,
			hide: { effect: 'clip', duration: 500 },
			show: { effect: 'scale', duration: 600 },
			open: function() {
				enableBts(false);
				$.ajax({
					type: 'GET', url: window.links.studentAjaxFetchOrders,
					data: { kontrahentId: KONTRAHENT_ID },
					success: function(data) {
						$('#bzOrdersTable table thead tr th:first-child').html('Dziedzina');
                                                $('#bzOrdersTable table thead tr th:first-child+th').html('Poziom');
						console.log(data);
						if (data.error) return;
						var html = '';
						for (var i in data.data)
						{
							var order = data.data[i];
							var action = '';
							if (order.attended)
								action = 'Aplikacja została wysłana.';
							else if (order.enabled)
								action = '<a href="#" data-tenderId="' + order.id + '">[Aplikuj]</a>';
							else
								action = 'Brak wymaganych certyfikatów.';
							html += '<tr' + (order.enabled?'':' class="disabled"')
								+ '><td><?php echo $kontrahent->dziedzina->nazwa; ?></td><td>'
								+ order.level + '</td><td act-tender-id="' + order.id + '">' + action + '</td></tr>';
						}
						$('#bzOrdersContainer').html(html);
						$('#bzOrdersContainer').find('a[data-tenderId]').click(function(){
							var tenderId = $(this).attr('data-tenderId');
							var tender = null;
							for (var i in data.data)
							{
								var order = data.data[i];
								if (order.id == tenderId)
									tender = order;
							}
							if (tender == null) return;
							applayToTender(tender, function(){
								$('[act-tender-id="' + tenderId + '"]').html('Aplikacja została wysłana.');
							});
							return false;
						});
						$('#bzOrdersWait').fadeOut(400, function(){$('#bzOrdersTable').fadeIn();});
					},
					complete: function() { enableBts(true); }
				});
			},
			close: function() {
				$('#bzOrdersContainer').html('');
				$('#bzOrdersTable').hide();
				$('#bzOrdersWait').show();
				$(this).parent().remove();
			},
			position: { my: "center", at: "center", of: window },
			draggable: true, resizable: false,
			width: 900, height: 400
		});
	});

<?php
$englishDomain = array(
		1 => "Mathematics",
		2 => "Physics",
		3 => "Biology",
		4 => "Chemistry",
);
?>

	$(document).on('ordersListEn.przedsiebiorcaDialogueEvents', function(){
		$('#bzOrdersTable').show();
		$('#bzOrdersWait').hide();
		$('#bzOrdersDialog').dialog({
			title: 'Tenders',
			modal: true, autoOpen: true,
			closeOnEscape: false,
			hide: { effect: 'clip', duration: 500 },
			show: { effect: 'scale', duration: 600 },
			open: function() {
				enableBts(false);
				$.ajax({
					type: 'GET', url: window.links.studentAjaxFetchOrders,
					data: { kontrahentId: KONTRAHENT_ID, lang: 1 },
					success: function(data) {
						console.log(data);
						$('#bzOrdersTable table thead tr th:first-child').html('Field');
						$('#bzOrdersTable table thead tr th:first-child+th').html('Level');
						if (data.error) return;
						var html = '';
						for (var i in data.data)
						{
							var order = data.data[i];
							var action = '';
							if (order.attended)
								action = 'Your application has ben sent.';
							else if (order.enabled)
								action = '<a href="#" data-tenderId="' + order.id + '">[Apply]</a>';
							else
								action = 'You do not have the required certificates.';
							html += '<tr' + (order.enabled?'':' class="disabled"')
								+ '><td><?php echo $englishDomain[$kontrahent->dziedzina->id]; ?></td><td>'
								+ order.level + '</td><td act-tender-id="' + order.id + '">' + action + '</td></tr>';
						}
						$('#bzOrdersContainer').html(html);
						$('#bzOrdersContainer').find('a[data-tenderId]').click(function(){
							var tenderId = $(this).attr('data-tenderId');
							var tender = null;
							for (var i in data.data)
							{
								var order = data.data[i];
								if (order.id == tenderId)
									tender = order;
							}
							if (tender == null) return;
							applayToTender(tender, function(){
								$('[act-tender-id="' + tenderId + '"]').html('Your application has ben sent.');
							});
							return false;
						});
						$('#bzOrdersWait').fadeOut(400, function(){$('#bzOrdersTable').fadeIn();});
					},
					complete: function() { enableBts(true); }
				});
			},
			close: function() {
				$('#bzOrdersContainer').html('');
				$('#bzOrdersTable').hide();
				$('#bzOrdersWait').show();
				$(this).parent().remove();
			},
			position: { my: "center", at: "center", of: window },
			draggable: true, resizable: false,
			width: 900, height: 400
		});
	});






})();
</script>

<div class="biuroZleceniaXrDialogCls" id="bzOrdersDialog">
	<table id="bzOrdersWait">
		<tr>
			<td>Proszę czekać...</td>
		</tr>
	</table>
	<div id="bzOrdersTable">
		<table>
			<thead>
				<tr>
					<th>Dziedzina</th>
					<th>Poziom</th>
					<th></th>
				</tr>
			</thead>
			<tbody id="bzOrdersContainer">

			</tbody>
		</table>
	</div>
</div>

<style type="text/css">
	#biuroZleceniaXrDialog .disabled, #bzOrdersTable .disabled {color: silver}
	#biuroZleceniaXrTender .error {color:red}
	#biuroZleceniaXrTender .errorMsg {display:none}
	#biuroZleceniaXrTender .error .errorMsg {display:block}
</style>
